#ifndef _MAIN_H
#define _MAIN_H

#define PADTIMEOUTSTOP     300L  // we allstop() after not hearing from the pad for this long
#define EVENTCHAR          0xEE
#define DIAG_BUTTON_THRESH 512L

#define HOSTBUFSIZE       128  // must be a power of 2
#define PADBUFSIZE        128 // power of two
#define SLAVEBUFSIZE      64 // power of two
#define SLAVESTATEBUFSIZE 80

#define PINMODE_DIG_IN 			0
#define PINMODE_DIG_IN_PULLUP   1
#define PINMODE_DIG_IN_PULLDN   2

#define PINMODE_DIG_OUT_STRONG  3
#define PINMODE_DIG_OUT_SLOW    4

#define PINMODE_SERVO			5
#define PINMODE_SONAR_PING		6
#define PINMODE_SONAR_ECHO		7

#define PINMODE_ANALOG_IN       8

#define PINMODE_ANALOG_OUT      9
#define PINMODE_CLOCK_OUT       10

#define PINMODE_QUADPHASE       11
#define PINMODE_MONOPHASE       12
#define PINMODE_MAX             12


#define ALLSTOP_PADTIMEOUT		1
#define ALLSTOP_STOPBUTTON      2
#define ALLSTOP_SOFTWAREREQ     3

void doAnalog(void);
void doHost(void);
void doHostMessage(void);
void doPad(void);
void doPadMessage(void);
void doSlave(void);
void doSlaveMessage(void);
void updateAnalog(void);
void idle(void);
void commerror(unsigned char type);
void allstop(unsigned char type);

extern unsigned char pad_joyx, pad_joyy, pad_buttons;
extern unsigned char pad_move_up, pad_move_down, pad_move_left, pad_move_right;
extern unsigned char slave_ack;
extern unsigned int  sleepcounter;
extern unsigned char slavestate[SLAVESTATEBUFSIZE];
extern int servowidth[4];


#endif
